#!/bin/bash -f
#*********************************************************************************************************
# Vivado (TM) v2019.1 (64-bit)
#
# Filename    : pdm_to_pcm.sh
# Simulator   : Synopsys Verilog Compiler Simulator
# Description : Simulation script for compiling, elaborating and verifying the project source files.
#               The script will automatically create the design libraries sub-directories in the run
#               directory, add the library logical mappings in the simulator setup file, create default
#               'do/prj' file, execute compilation, elaboration and simulation steps.
#
# Generated by Vivado on Mon May 25 03:27:13 +0200 2020
# SW Build 2552052 on Fri May 24 14:49:42 MDT 2019
#
# Copyright 1986-2019 Xilinx, Inc. All Rights Reserved. 
#
# usage: pdm_to_pcm.sh [-help]
# usage: pdm_to_pcm.sh [-lib_map_path]
# usage: pdm_to_pcm.sh [-noclean_files]
# usage: pdm_to_pcm.sh [-reset_run]
#
# Prerequisite:- To compile and run simulation, you must compile the Xilinx simulation libraries using the
# 'compile_simlib' TCL command. For more information about this command, run 'compile_simlib -help' in the
# Vivado Tcl Shell. Once the libraries have been compiled successfully, specify the -lib_map_path switch
# that points to these libraries and rerun export_simulation. For more information about this switch please
# type 'export_simulation -help' in the Tcl shell.
#
# You can also point to the simulation libraries by either replacing the <SPECIFY_COMPILED_LIB_PATH> in this
# script with the compiled library directory path or specify this path with the '-lib_map_path' switch when
# executing this script. Please type 'pdm_to_pcm.sh -help' for more information.
#
# Additional references - 'Xilinx Vivado Design Suite User Guide:Logic simulation (UG900)'
#
#*********************************************************************************************************

# Directory path for design sources and include directories (if any) wrt this path
ref_dir="."

# Override directory with 'export_sim_ref_dir' env path value if set in the shell
if [[ (! -z "$export_sim_ref_dir") && ($export_sim_ref_dir != "") ]]; then
  ref_dir="$export_sim_ref_dir"
fi

# Command line options
vlogan_opts="-full64"
vhdlan_opts="-full64"
vcs_elab_opts="-full64 -debug_pp -t ps -licqueue -l elaborate.log"
vcs_sim_opts="-ucli -licqueue -l simulate.log"

# Design libraries
design_libs=(xil_defaultlib xpm xbip_utils_v3_0_10 axi_utils_v2_0_6 cic_compiler_v4_0_14 fir_compiler_v7_2_12 fifo_generator_v13_2_4 util_vector_logic_v2_0_1 c_reg_fd_v12_0_6 xbip_dsp48_wrapper_v3_0_4 xbip_pipe_v3_0_6 xbip_dsp48_addsub_v3_0_6 xbip_addsub_v3_0_6 c_addsub_v12_0_13 blk_mem_gen_v8_4_3 c_mux_bit_v12_0_6 c_shift_ram_v12_0_13 xbip_bram18k_v3_0_6 mult_gen_v12_0_15)

# Simulation root library directory
sim_lib_dir="vcs_lib"

# Script info
echo -e "pdm_to_pcm.sh - Script generated by export_simulation (Vivado v2019.1 (64-bit)-id)\n"

# Main steps
run()
{
  check_args $# $1
  setup $1 $2
  compile
  elaborate
  simulate
}

# RUN_STEP: <compile>
compile()
{
  # Compile design files
  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "C:/xilinx/Vivado/2019.1/data/ip/xpm/xpm_cdc/hdl/xpm_cdc.sv" \
    "C:/xilinx/Vivado/2019.1/data/ip/xpm/xpm_memory/hdl/xpm_memory.sv" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xpm $vhdlan_opts \
    "C:/xilinx/Vivado/2019.1/data/ip/xpm/xpm_VCOMP.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_utils_v3_0_10 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/1123/hdl/xbip_utils_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_utils_v2_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/1971/hdl/axi_utils_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work cic_compiler_v4_0_14 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/04e3/hdl/cic_compiler_v4_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_cic_compiler_0_0/sim/pdm_to_pcm_cic_compiler_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work fir_compiler_v7_2_12 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c2da/hdl/fir_compiler_v7_2_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_fir_compiler_0_0/sim/pdm_to_pcm_fir_compiler_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_fir_compiler_1_0/sim/pdm_to_pcm_fir_compiler_1_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_clk_wiz_0_0/pdm_to_pcm_clk_wiz_0_0_clk_wiz.v" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_clk_wiz_0_0/pdm_to_pcm_clk_wiz_0_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work fifo_generator_v13_2_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/1f5a/simulation/fifo_generator_vlog_beh.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work fifo_generator_v13_2_4 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/1f5a/hdl/fifo_generator_v13_2_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work fifo_generator_v13_2_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/1f5a/hdl/fifo_generator_v13_2_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_fifo_generator_0_0/sim/pdm_to_pcm_fifo_generator_0_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work util_vector_logic_v2_0_1 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/2137/hdl/util_vector_logic_v2_0_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_util_vector_logic_0_0/sim/pdm_to_pcm_util_vector_logic_0_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_clk_div_0_0/sim/pdm_to_pcm_clk_div_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_util_ds_buf_0_0/util_ds_buf.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_util_ds_buf_0_0/sim/pdm_to_pcm_util_ds_buf_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_clk_div_1_0/sim/pdm_to_pcm_clk_div_1_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_hp_filter_0_0/sim/pdm_to_pcm_hp_filter_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_util_vector_logic_0_2/sim/pdm_to_pcm_util_vector_logic_0_2.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_timemux_0_2/sim/pdm_to_pcm_timemux_0_2.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_demux16_sync_0_0/sim/pdm_to_pcm_demux16_sync_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work c_reg_fd_v12_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/edec/hdl/c_reg_fd_v12_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_dsp48_wrapper_v3_0_4 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/cdbf/hdl/xbip_dsp48_wrapper_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_pipe_v3_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/7468/hdl/xbip_pipe_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_dsp48_addsub_v3_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/910d/hdl/xbip_dsp48_addsub_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_addsub_v3_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/cfdd/hdl/xbip_addsub_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work c_addsub_v12_0_13 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/cbe4/hdl/c_addsub_v12_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_addsub_0_0/sim/pdm_to_pcm_c_addsub_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_addsub_0_1/sim/pdm_to_pcm_c_addsub_0_1.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_addsub_1_0/sim/pdm_to_pcm_c_addsub_1_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work blk_mem_gen_v8_4_3 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c001/simulation/blk_mem_gen_v8_4.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_blk_mem_gen_0_0/sim/pdm_to_pcm_blk_mem_gen_0_0.v" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_blk_mem_gen_1_0/sim/pdm_to_pcm_blk_mem_gen_1_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work c_mux_bit_v12_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/ecb4/hdl/c_mux_bit_v12_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work c_shift_ram_v12_0_13 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/cd8a/hdl/c_shift_ram_v12_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_shift_ram_0_0/sim/pdm_to_pcm_c_shift_ram_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_shift_ram_1_0/sim/pdm_to_pcm_c_shift_ram_1_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_shift_ram_1_1/sim/pdm_to_pcm_c_shift_ram_1_1.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_c_shift_ram_1_2/sim/pdm_to_pcm_c_shift_ram_1_2.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/c923" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_blk_mem_gen_1_1/sim/pdm_to_pcm_blk_mem_gen_1_1.v" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_blk_mem_gen_2_0/sim/pdm_to_pcm_blk_mem_gen_2_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_scan_0_0/sim/pdm_to_pcm_scan_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_energy_compare_0_0/sim/pdm_to_pcm_energy_compare_0_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xbip_bram18k_v3_0_6 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/d367/hdl/xbip_bram18k_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work mult_gen_v12_0_15 $vhdlan_opts \
    "$ref_dir/../../../../dat096_ref_design.srcs/sources_1/bd/pdm_to_pcm/ipshared/d4d2/hdl/mult_gen_v12_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/pdm_to_pcm/ip/pdm_to_pcm_mult_gen_0_0/sim/pdm_to_pcm_mult_gen_0_0.vhd" \
    "$ref_dir/../../../bd/pdm_to_pcm/sim/pdm_to_pcm.vhd" \
  2>&1 | tee -a vhdlan.log


  vlogan -work xil_defaultlib $vlogan_opts +v2k \
    glbl.v \
  2>&1 | tee -a vlogan.log

}

# RUN_STEP: <elaborate>
elaborate()
{
  vcs $vcs_elab_opts xil_defaultlib.pdm_to_pcm xil_defaultlib.glbl -o pdm_to_pcm_simv
}

# RUN_STEP: <simulate>
simulate()
{
  ./pdm_to_pcm_simv $vcs_sim_opts -do simulate.do
}

# STEP: setup
setup()
{
  case $1 in
    "-lib_map_path" )
      if [[ ($2 == "") ]]; then
        echo -e "ERROR: Simulation library directory path not specified (type \"./pdm_to_pcm.sh -help\" for more information)\n"
        exit 1
      fi
      create_lib_mappings $2
    ;;
    "-reset_run" )
      reset_run
      echo -e "INFO: Simulation run files deleted.\n"
      exit 0
    ;;
    "-noclean_files" )
      # do not remove previous data
    ;;
    * )
      create_lib_mappings $2
  esac

  create_lib_dir

  # Add any setup/initialization commands here:-

  # <user specific commands>

}

# Define design library mappings
create_lib_mappings()
{
  file="synopsys_sim.setup"
  if [[ -e $file ]]; then
    if [[ ($1 == "") ]]; then
      return
    else
      rm -rf $file
    fi
  fi

  touch $file

  lib_map_path=""
  if [[ ($1 != "") ]]; then
    lib_map_path="$1"
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    mapping="$lib:$sim_lib_dir/$lib"
    echo $mapping >> $file
  done

  if [[ ($lib_map_path != "") ]]; then
    incl_ref="OTHERS=$lib_map_path/synopsys_sim.setup"
    echo $incl_ref >> $file
  fi
}

# Create design library directory paths
create_lib_dir()
{
  if [[ -e $sim_lib_dir ]]; then
    rm -rf $sim_lib_dir
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    lib_dir="$sim_lib_dir/$lib"
    if [[ ! -e $lib_dir ]]; then
      mkdir -p $lib_dir
    fi
  done
}

# Delete generated data from the previous run
reset_run()
{
  files_to_remove=(ucli.key pdm_to_pcm_simv vlogan.log vhdlan.log compile.log elaborate.log simulate.log .vlogansetup.env .vlogansetup.args .vcs_lib_lock scirocco_command.log 64 AN.DB csrc pdm_to_pcm_simv.daidir)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done

  create_lib_dir
}

# Check command line arguments
check_args()
{
  if [[ ($1 == 1 ) && ($2 != "-lib_map_path" && $2 != "-noclean_files" && $2 != "-reset_run" && $2 != "-help" && $2 != "-h") ]]; then
    echo -e "ERROR: Unknown option specified '$2' (type \"./pdm_to_pcm.sh -help\" for more information)\n"
    exit 1
  fi

  if [[ ($2 == "-help" || $2 == "-h") ]]; then
    usage
  fi
}

# Script usage
usage()
{
  msg="Usage: pdm_to_pcm.sh [-help]\n\
Usage: pdm_to_pcm.sh [-lib_map_path]\n\
Usage: pdm_to_pcm.sh [-reset_run]\n\
Usage: pdm_to_pcm.sh [-noclean_files]\n\n\
[-help] -- Print help information for this script\n\n\
[-lib_map_path <path>] -- Compiled simulation library directory path. The simulation library is compiled\n\
using the compile_simlib tcl command. Please see 'compile_simlib -help' for more information.\n\n\
[-reset_run] -- Recreate simulator setup files and library mappings for a clean run. The generated files\n\
from the previous run will be removed. If you don't want to remove the simulator generated files, use the\n\
-noclean_files switch.\n\n\
[-noclean_files] -- Reset previous run, but do not remove simulator generated files from the previous run.\n\n"
  echo -e $msg
  exit 1
}

# Launch script
run $1 $2
